
markup.push({

// -------------------------------------------------
// MARK: Transcribe
TranscribeBlock:
{
	"+": "BlockTemplate",
	gxTitle: "Transcribe",
	geNodeClass: "GETranscribeNode",
    gxFaceModel: {
        nsClass: "H4TranscribeBlockFace",
        gxFaceModelKeyPath: "faceModel",
    },
	gxPopoverInfo: "TranscribePopover",
    maximumInputs: 5,
	h4PresetsId: "TranscribePresets4",
	gxLibraryDescription: "Transcribe audio to a text file",
    gxIconPainter: {
        "+" : "ImagePainter.block.transcribe",
        gxEdgeInsets: "0,-6,0,0",
    },
	gxLibraryIcon: "library.transcribe",
    geOutputRank: 2,
    gxSocketView: "TranscrbieSocketView",
    geOutputVerb: "Transcribing",
	gxChildViews: {
		spinnerHost:
		{
			nsClass: "GXLayerHostingView",
			gxFrameRect: "16,89,16,16",
			gxRootLayer:
			{
				nsClass: "GXCaarLayer",
				gxViewName: "spinner",
                gxValueKey: "spinnerValue",
				gxAnimateOnKey: "node.transcribing",
				gxShowOnKey: "node.transcribing",
				gxAnimationDivider: 2,
				gxCaarPainter: "TranscribePencilPainter.blockFace",
				gxTransition: {
					nsClass: "GXSpinnerTransition",
					gxDuration: 1.0,
					gxRunOn: 1.0,
				},
			}
		}, 
		status: {
			"+": "LabelView",
            gxForePainter: {
                "+" : "LabelFore.thinWeight.size11",
                gxHAlign: 0.5,
                gxFontColor : "WhiteColor",
                "transcribe" : {
                    gxEdgeInsets: "14,0,0,0",
                    gxFontColor : "ColorThemeLive3"
                },
            },
			gxFrameRect: "0,88,120,22",
			gxDefaultValue: "Transcribing",
            gxValueKey: "status",
			gxAnimateOnKey: "node.transcribing",
			axIsIgnored: true, 
		},
	},
}, 
    
    
TranscrbieSocketView:
{
    "+": "SocketView",
    gxIndicatorPainter:
    {
        "+": "LabelFore.boldWeight.size10",
        input0: { gxDefaultString: "1" },
        input1: { gxDefaultString: "2" },
        input2: { gxDefaultString: "3" },
        input3: { gxDefaultString: "4" }, 
        input4: { gxDefaultString: "5" },
        gxFontColor: "ForeColorTheme1",
        active : {
            gxFontColor: "BlackColor",
        },
        gxEdgeInsets: "1.5, 1.5, 1.5, 1.5",
    },
},
    
// MARK: popover

TranscribePopover:
{
    "+": "PopoverTemplate",
    gxTitle: "Transcribe",
	gxCanDrawSubviewsIntoLayer: true,
    gxLayout: [
        "H:|-12-[self(>=400)]-12-|",
        "V:|-12-[self]-12-|",
        "V:|-41-[group]-6-[presetsGroup]",
        "H:|-5-[betaBadge(40)]",
        "H:[betaBadge]->=0-[presetsGroup]&alignCenterY",
        "V:[betaBadge(40)]"
    ],
    gxChildViews:
    {
        title: "PopoverTitle",
        onOff: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
        betaBadge: {
            "+" : "ImageButtonView.colorThemeLive1.beta-logo",
            gxValueKey: "node.betaButtonPressed",
            axIsIgnored: true,
        },
		group:
		{
			"+": "GroupView",
			gxLayout: [
				"H:|[self]|", 
				"V:|[modelGroup][otherGroup]|"
			],
			gxChildViews :
			{  
				modelGroup: {
					"+": "GroupView.noStroke",
					//axIsIgnored: false, 
					//axTitle: "Advanced",
					gxCollapsible: false, 
					gxLayout: [
						"H:|-0-[self]-0-|", 
						"H:|-12-[modelLabel(60)]-8-[modelPopup]-12-|&alignCenterY",
						"V:|-10-[modelPopup]-0-[languagePrefs]-6-[whisperLabel(12)]-0-[modelPerformanceWarning]-0-|&alignLeft",
                        "H:[whisperLabel(==modelPopup)]",
                        "H:[languagePrefs]|",
						"H:[modelPerformanceWarning]-0-|",
					],
					gxChildViews: {
						modelLabel: labelView("Model:"),
						modelPopup : {
							"+": "PopupMenuTemplate",
							axTitle: "Transcription Model",
							gxDisableOnKey: "running",
							gxHideOnNilValue: false,
							gxValueKey: "node.modelMenuSelectedPath",
							gxMenuItemsKeyPath: "node.modelMenuItems"
						},
                        languagePrefs: {
                            "+": "ExpandingGroupView.noStroke",
                            gxCollapsedSize: 0,
                            gxExtraSize: 6,
                            gxValueKey: "node.hasModels",
                            gxLayout: [
                                "H:|-0-[languagePopupLabel(72)]-8-[languagePopup]-12-|&alignCenterY",
                                "V:|-10-[languagePopup]"
                            ],
                            gxChildViews: {
                                languagePopup: {
                                    "+": "PopupMenuTemplate",
                                    gxMenuItemsKeyPath: "node.languageMenuItems",
                                    gxValueKey: "node.preferredLanguage",
                                    gxHideOnNilValue: false,
                                    gxDisableOnKey: "running",
                                    gxLabelText: "Language:"
                                },
                            }
                        },
                        whisperLabel: {
                            "+" : "LabelView",
                            gxForePainter: {
                                "+" : "LabelFore.size11.left",
                                gxEdgeInsets: "10,0,0,0",
                            },
                            gxDefaultValue: "Powered by Whisper",
                        },
						modelPerformanceWarning: {
							"+": "ExpandingGroupView.noStroke",
							gxValueKey: "node.showModelPerformanceWarning",
							gxCollapsedSize: 0,
							gxExtraSize: 4,
                            gxLayout: [
                                "H:|-0-[warningText]-12-|",
								"V:|-7-[warningText(55)]",
                                "H:|-10-[warningImage(18)]",
                                "V:|-17-[warningImage(18)]",
							],
							gxChildViews: {
                                "warningImage" : { "+": "ImageView.iconSize20.icon-warning" },
								"warningText" : {
									"+": "LabelView",
                                    gxBackPainter: roundRectPainter("NoticeFillColor", 8),
                                    gxForePainter: {
                                        "+" : "LabelFore.wrap.top.left.size11.thinWeight",
                                        gxFontColor: "WhiteOrBlack",
                                        gxEdgeInsets: "40,7,15,0",
                                    },
									gxIntrinsicWidth: -1,
									gxDefaultValue: "Transcribe works best on Apple Silicon-based computers. It may perform poorly on this older Intel-based Mac.",
								},
							}
						}
								
					},
				},
				otherGroup: {
					"+": "ExpandingGroupView.noStroke", 
					gxValueKey: "node.hasModels", 
					gxLayout: [
						"H:|[self]|",
						"V:|[diarization][outputButton][outputGroup]"
					],
					gxChildViews: {  
						diarization: {
							"+" : "ExpandingGroupView.noStroke", 
							gxValueKey: "node.hasModels",
							gxCollapsedSize: 0,	// lets bottom stroke show 
							gxExtraSize: 6,	
							gxLayout: [
								"H:|-0-[self]-0-|", 
                                "V:|[track0][track1][track2][track3][track4]"
							],
                            gxChildViews : [
                                TrackView(0),
                                TrackView(1),
                                TrackView(2),
                                TrackView(3),
                                TrackView(4),
                            ],
						},
						
						outputButton: {
							"+": "AdvancedGroupButton",
							gxTitle: "<disclosure/> Output",
							gxDefaultValue: true,	// expanded
							gxValueKey: "uiState.outputExpanded",
							axFormatter: disclosureAxFormatter("Output"),
						},
						
						outputGroup: {
							"+": "ExpandingGroupView.noTopStroke",  
							gxValueKey: "uiState.outputExpanded",
							gxExtraSize: 12,
                            gxDefaultValue: true,    // expanded
							gxCollapsedSize: 1,	// lets bottom stroke show
							gxLayout: [
								"H:|-0-[self]-0-|",  
								"H:|-85-[name]",
								"H:[nameLabel]-[name]-12-|&alignBaseline",
								
								"H:[directoryLabel]-[directory]&alignBaseline",
								"H:[directory]-[loupe(20)]-10-|",
								"V:[directory]-(-21)-[loupe(20)]", 
		
								"V:|-10-[name]-10-[directory]&alignLeft",
							],
							gxChildViews: {
								name: {
									"+": "TranscribeTokenField",
									gxValueKey: "node.fileName",	
									gxLabelText: "File name:"
								},
								directory: {
									"+": "PopupMenuTemplate",
									gxMenuItemsKeyPath: "node.folderMenuItems",
									gxValueKey: "node.folderMenuSelectedPath",
									gxHideOnNilValue: false,
									gxDisableOnKey: "running",
									gxLabelText: "Save to:"
								},
								loupe: {
									"+": "ImageButtonView.loupe",
									gxValueKey: "node.folderLoupeBtn",
									axTitle: "Folder Reveal"
								},
							}, 
						},  
					}
				}, 
			},
        },
    }
}, 
	// -------------------------------------------------
// MARK: recorder token field

TranscribeTokenField:
{
    "+": "TokenField",
    gxDisableOnKey: "running",
	axHelp: "Tokens can be added to this field from the context menu",
	
    // menu of tokens as displayed to user
    gxMenuItems:
    [
        {    gxTitle: "Session Name",        		gxValue: "%name" },
        {    gxTitle: "File Counter",        			gxValue: "%counter" },
		{    gxTitle: "Zero-Prefixed Counter",     gxValue: "%prefixed_counter" },
        {    gxTitle: "-" },
        {    gxTitle: "Date",                gxValue: "%date" },
        {    gxTitle: "Year",                gxValue: "%year" },
        {    gxTitle: "Month",            gxValue: "%month" },
        {    gxTitle: "Day",                gxValue: "%day" },
        {    gxTitle: "-" },
        {    gxTitle: "Time",                gxValue: "%time" },
        {    gxTitle: "Hour",                gxValue: "%hour" },
        {    gxTitle: "Minute",            gxValue: "%minute" },
        {    gxTitle: "Second",            gxValue: "%second" }, 
    ],
    // all allowable tokens, and the display names they use in cells
    gxTokenNames:
    {
        "%name":                "Session",
		"%counter":            "Counter",
        "%prefixed_counter":    "Prefixed Counter",
        "%index":            "Counter",    // AHP used %index for %counter, we allow it
        "%date":                "Date",
        "%year":                "Year",
        "%month":            "Month",
        "%day":                "Day",
        "%time":                "Time",
        "%hour":                "Hour",
        "%minute":            "Minute",
        "%second":            "Second", 
    }
},

TranscribeDiarizationTokenField:
{
	"+": "TokenField",
	gxDisableOnKey: "running",
	axHelp: "Tokens can be added to this field from the context menu",

	// menu of tokens as displayed to user
	gxMenuItems:
	[
		{    gxTitle: "Source",         gxValue: "%source" },
        {    gxTitle: "Timestamp",      gxValue: "%timestamp" },
	],
	
	// all allowable tokens, and the display names they use in cells
    gxTokenNames:
    {
        "%timestamp":                "Timestamp",  
        "%source":                   "Source",
    },
},
    
// MARK: Animation
    
TranscribePencilPainter:   // caar painter!
{
    nsClass: "GXCaarPainter",
    gxDuration: 2.5,
    gxForePainter: "",
    transcribe:
    {
        gxAsset: "transcribing",
        gxTintColor: "ColorThemeLive3",
        gxAssetDuration: 2.5,
        gxLoopStart: 0.0,
        gxPlaybackSpeed: 1,
    },
    gxHAlign: 0.5,
    gxVAlign: 0.5,
},
    

})

function TrackView(trackNumber)
{
	return {
		"+": "ExpandingGroupView.noStroke",
        gxViewName: `track${trackNumber}`,
		gxValueKey: `node.showTrack${trackNumber}`,
		gxLayout: [
            "H:|[self]|",
            "H:|-25-[trackNameLabel]-[trackName]-12-|&alignBaseline",
			"V:|-8-[trackName]"
		],
		gxExtraSize: 6,
		gxChildViews: {
			trackName: {
				"+": "TranscribeDiarizationTokenField",
                gxToolTipKeyPath: `node.trackToolTip${trackNumber}`,
				gxNilWhenEmpty: false,
				gxDisableOnNil: false,
				gxDisableOnKey: "",
				gxIsSingleLine: true, 
				gxValueKey: `node.setSpeakerFormat${trackNumber}`,  
				gxFocusRingPainter: "ControlBack",
				gxBackPainter: "ControlBack",
                axTitle: "Speaker format field",
                axHelp: `VO press to edit speaker format for input ${trackNumber + 1}`,
				gxTextPainter: { "+": "ControlFore", gxHAlign: 0 },
				gxEdgeInsets: "10,4,0,0", 
                gxLabelText: "Input " + (trackNumber + 1) + ":",
			},
		},
	};
}
